'Version with faster Sprite Routine from mmbasic 5.08.00 ff.
'2022 - 2024 Martin Herhaus
'used the modyfications by vegipete for storing the Trackdata
'
'
Option explicit
Dim integer Bcl(16,120),Col%(15),Xofs%(160),spr%(20)
Dim integer xdr,xd2,f%,n%,sh%,sw%,t%,hh%,hw%,dist%,speed%,ppos%,turn%,dur%
Dim integer an,bb%,bc%,b1x%,b2x%,b3x%,b4x%,ofs%,PDst,y%,ft
Dim float cu,dst,spt,fcnt,i
Dim integer mv1%=1,mv2%=2,spaddr%,x
Restore colors:For f%=1 To 15:Read Col%(f%):Next f%
MODE 2:SH%=MM.VRes:SW%=MM.HRes:HW%=SW%/2:HH%=SH%/2
dist%=0:Speed%=20:PPos%=0

Option Break 4: On Key 3, on_break
FRAMEBUFFER create:FRAMEBUFFER WRITE F
read_sprites
Colour 0
'Precalc the Curve
For f%=0 To 159:Xofs%(159-f%)=-((160*Exp(f%/50))/20)-8:Next
'Precalc the Bordercolors
For dst=0 To 15:For f%=0 To 120
bcl(dst,f%)=col%(7-3*((Sin((((120-f%)/40)^3)+dst*.37))>0)):Next :Next :dst=0
spt=1
CLS : Load image "sky.bmp":Box 0,hh%+1,320,1,,0,col%(10)


'-------endless loop -----------------------
' n is degree of bend
n%=0   ' current curvature - start off straight
t%=Timer:fcnt=0
Restore TrackData
Do
Read turn%,dur%
ft=Timer
If dur% < 0 Then
  t%=(Timer-t%)/1000
  Text 1,1,Str$(fcnt/t%,3,3),,,,RGB(White) ' show framerate
  t%=Timer:fcnt=0
  Restore TrackData
  Continue Do ' restart the track
EndIf
If n% < turn% Then  ' adjust curvature towards left
  For i = n% To turn% Step Speed%/dur%*100
    DrawTrack i
    do_car -Sgn(i):Mosky -Sgn(i)
    FRAMEBUFFER COPY F,N:Inc fcnt
    Pause 40-(Timer-ft):ft=Timer
  Next
  n%=turn%
  ElseIf n% > turn% Then  ' more to right
  For i = n% To turn% Step -Speed%/dur%*100
    DrawTrack i:do_car -Sgn(i):Mosky -Sgn(i)
    FRAMEBUFFER COPY F,N:Inc fcnt
   Pause 40-(Timer-ft):ft=Timer

  Next
  n%=turn%
Else   ' continue along path
  For i = 1 To dur% 'Step Speed%/dur%
    DrawTrack n%:do_car -Sgn(n%):Mosky -Sgn(n%)
    FRAMEBUFFER COPY F,N:Inc fcnt
    Pause 40-(Timer-ft):ft=Timer
  Next
EndIf
Loop

'------------------------------
'b1x% left x position of the left Border
'b2x% right x position of the left Border and left x position of the street
'b3x% right x position of the street and left x position of the right Border
'b4x% right x position of the right Border
'BB% Border wight
'bc% Border Color (red or white) calculated over Sinus Function
'HH% Half Screen y-Res  HW% Half Screen x-Res
'PDist% Shift relative to Car Position PPos%
'xofs%() Pre calculated Curve over Exponetial function
'ofsx% stregth of the bend
'------------------------------

Sub DrawTrack curv
  Box 0,hh%+2,sw%,hh%-12,,COL%(2),COL%(2)
  For F%=2 To HH%-12 Step 2
PDst=PPos%*f%/HH%:BB%=f%>>2:y%=hh%+f%:b1x%=PDst+HW%-F%-bb%+xofs%(f%)*curv/100
b2x%=b1x%+BB%:b3x%=b2X%+f%+f%:b4x%=b3x%+BB%
    Box b1x%,y%,b4x%-b1x%,2,,bcl(dst,f%):Box b2x%,y%,f%+f%,2,,0,0
   Next
  Inc dst,spt:dst=dst Mod 15
End Sub

'--- Moves the Sky while driving a curve
' spt adjusts the border speed when there is nothing to Move
'  mv1% and mv2% are the differed Speeds for the "Paralax Effect"
'
Sub Mosky dir%
Select Case dir%
  Case 0
  spt=2:Exit Sub 'driving straight so sky doesn't change
  Case >0
    spt=3:xdr=320-mv2%:xd2=320-mv1%
    Sprite read 31,0,28,mv2%,22:Sprite Mv2%,28,0,28,xdr,22
    Sprite write 31,xdr,28:Sprite read 31,0,50,mv2%,22
    Sprite Mv1%,50,0,50,xd2,22:Sprite write 31,xd2,50
    Sprite read 30,0,102,mv2%,20:Sprite Mv2%,102,0,102,xdr,20
    Sprite write 30,xdr,102
  Case Else
    spt=3:xdr=320-mv2%:xd2=320-mv1%
    Sprite read 31,xdr,28,mv2%,22:Sprite 0,28,mv2%,28,xdr,22
    Sprite write 31,0,28:Sprite read 31,xdr,50,mv2%,22
    Sprite 0,50,mv1%,50,xd2,22:Sprite write 31,-mv1%,50
    Sprite read 30,xdr,102,mv2%,20:Sprite 0,102,mv2%,102,xdr,20
    Sprite write 30,0,102
  End Select
End Sub

Sub do_car dir%
Local Key$
If Not dir% Then
   Sprite memory spr%(1+an),132,200,9
'  Sprite write #1+an,132,200,4
Else
   If dir%<0 Then Sprite memory spr%(5+an),132,200,9
   If dir%>0 Then Sprite memory spr%(3+an),132,200,9
  'Sprite write #3,132,200,4+(dir%<0)
EndIf
' move with "o" and "p"
 key$=Inkey$
 Select Case key$
Case "o":Inc  PPos%,8*(PPos%<160)
   Case "p":Inc PPos%,-8*(PPos%>-160)
  End Select
  an=Not an
End Sub

'----

Sub read_Sprites
    Restore PL_index
    spaddr% = Peek(CFUNADDR Player_Data)
    For y=1 To 10:Read x:spr%(y)=spaddr%+x:Next
End Sub
Sub on_break
Sprite CLOSE all: FRAMEBUFFER CLOSE
MODE 1: Option Break 3
End
End Sub

colors:
'--Colorscheme accordung to matherp
Data RGB(BLUE),RGB(GREEN),RGB(CYAN),RGB(RED)
Data RGB(MAGENTA),RGB(YELLOW),RGB(WHITE)
Data RGB(MYRTLE),RGB(COBALT),RGB(MIDGREEN),RGB(CERULEAN)
Data RGB(RUST),RGB(FUCHSIA),RGB(BROWN),RGB(LILAC)


TrackData:
' encoded track
' first value is amount of curve, negative = right, 100 is just off screen
' second value is duration of segment, negative = end of track, restart

Data    0,200   ' straight for a bit

Data  -50,300   ' turn to right
Data -130,300   ' turn even sharper to right
Data -130, 80   ' turn even sharper to right
Data    0,800   ' return to straight

Data    0,50    ' straight for a bit
Data   30,200   ' turn to the left
Data   30,180    ' turn to the left
Data    0,500   ' return to straight

Data    0,120   ' straight for a bit
Data -100,300   ' turn to right
Data -100,80   ' turn to right
Data    0,300   ' return to straight

Data    0,120   ' straight for a bit
Data  150,280  ' turn to right
Data  150,80  ' turn to right
Data    0,300  ' return to straight

Data    0,120   ' straight for a bit
Data  -50,200   ' turn to right
Data  -60,100   ' turn even sharper to right
Data  -60, 80   ' turn even sharper to right
Data    0,400   ' return to straight

Data    0,120   ' straight for a bit
Data  -20,200   ' turn to right
Data  -30,100   ' turn even sharper to right
Data  -30,100   ' turn even sharper to right
Data  -20,200   ' turn to right
Data  -100,300  ' turn to right
Data  -100,150  ' turn to right
Data    0,400   ' return to straight
Data    0,200   ' straight
Data    0,-200  ' end of track

'Sprite data
PL_Index:
Data 0,428,856,1256,1656,2060,2460,2756,3036,3412
CSub Player_data
00000000
'Offset  0
'PPC00 is compressed
801D0038
9F149B9F 12969F9F 9F9F12F2 129BF494 F49B1274 04F1929F 81C296F1 12E41271
96C28171 9FF104F1 03D201F1 82C21392 12E41271 13C28271 01D20392 06F19EF1
7181C413 7112E612 0613C481 05F19EF1 127181C8 817112E6 9EF105C8 72C904F1
7211C811 9EF104C9 81C303F1 72CA72C6 03C381C6 02F19EF1 C48D8FC4 F599F102
ABAF81C7 93F5C781 81C209F2 C2812B2F F192F209 AC81C10B C181AC82 F192F10B
D401D202 2C811102 11812C82 D201D402 F192F102 1B81110B 11811B84 F192F10B
1281110B 12511254 12511284 11811254 F192F10B 3153140B 84125112 31125112
F10B1453 120BF192 12315431 12841251 54311251 F10B1231 120BF192 D8511236
12361251 F192F10B 511A0AD1 0A1A51D8 F192F1D1 54130AD1 56D15113 541351D1
F1D10A13 0AD1F192 51135512 521252D1 551351D1 F1D10A12 120BF192 D1511454
D1521252 12541451 F192F10B 5212F10B 51113311 51D156D1 52113311 F10BF112
F10BF192 11511291 D1511133 1151D156 12511133 F10BF191 F10BF192 11331392
1151D851 F1921333 F192F10B 1395F10B F195139C F292F10B 9F9FF109 94F209F1
929F9FF9 000093F9
'Offset  428
'PPC01 is compressed
801D0038
9F149B9F 12969F9F 9F9F12F2 129BF494 F49B1274 04F1929F 81C296F1 12E41271
96C28171 9FF104F1 139206F1 127182C2 827112E4 069213C2 01F19EF1 C41303D2
E6127181 C4817112 01D20313 05F19EF1 127181C8 817112E6 9EF105C8 72C904F1
7211C811 9EF104C9 81C303F1 72CA72C6 03C381C6 02F19EF1 C48D8FC4 F599F102
ABAF81C7 93F5C781 81C209F2 C2812B2F F192F209 AC81C10B C181AC82 F192F10B
2C81110B 11812C82 F192F10B D401D202 1B811102 11811B84 D201D402 F192F102
1281110B 12511254 12511284 11811254 F192F10B 53140AD1 84125113 53135112
F1D10A14 0AD1F192 51135413 51128412 0A135413 F192F1D1 511A0AD1 0A1A51D8
F192F1D1 1236120B 1251D851 F10B1236 120BF192 12315431 D156D151 54311251
F10B1231 120BF192 51123155 521252D1 311251D1 F10B1255 120BF192 D1511454
D1521252 12541451 F192F10B 5212F10B 51113311 51D156D1 52113311 F10BF112
F10BF192 11511291 D1511133 1151D156 12511133 F10BF191 F10BF192 11331392
1151D851 F1921333 F192F10B 1395F10B F195139C F292F10B 9F9FF109 94F209F1
929F9FF9 000093F9
'Offset  856
'PPC02 is compressed
801D0038
9F149B9F 12969F9F 9F9F12F2 F412949F 9E9F9F12 E3F112F4 9F715412 04F1989F
12E3F112 817352E1 959FF59A 01D201F1 12E55112 98837351 9FF105F1 1204F194
7312E551 F195C185 F103D202 F195839A 8472CA04 05F113C5 99F10131 C785CC8C
31051281 F593F101 828FAB81 310584C7 F192F101 AD2A8105 0584C884 91F10151
AA8106F1 0AC1842D 015105F1 2A8207F2 0F84AB81 F2015102 D101D302 83150185
D302832A F20DD101 11028208 12511151 0B831786 91F10652 31110BF1 12513151
14511286 310A8251 92F50152 33120AF1 12861251 53311351 0152310A 0AF196F1
86D25115 31135112 52310A53 F196F101 D251150A 1351D385 52310A34 F196F101
1501D108 1751DA51 0152110A 08F196F1 511202D1 53D15111 531451D6 1101D108
96F10152 D1140CF1 D3521252 08531451 521101D1 F196F101 52D1150B 51D35212
D1085215 01521101 0BF196F1 D356D115 11511551 F101520B 150BF196 51D356D1
0E115115 0AF197F1 54D39114 F11651D3 F198F10E D896F109 F1931451 FA9AF10C
9FFC989F 949F9F9F 00000000
'Offset  1256
'PPC03 is compressed
801D0038
9F149B9F 12969F9F 9F9F12F2 F412949F 9E9F9F12 E3F112F4 9F715412 04F1989F
12E3F112 817352E1 959FF59A 511204F1 735112E5 05F19883 F1949FF1 1201D201
7312E551 F195C185 839AF107 CA04F195 13C58472 01D202F1 99F10151 C785CC8C
51051281 F593F101 828FAB81 510584C7 F192F101 AD2A8105 0584C884 91F10131
AA8106F1 0AC1842D 013105F1 2A8207F2 0F84AB81 F2013102 15018507 0F832A83
D301F205 8201D201 11511102 17861251 01D30183 065205D1 0BF191F1 51115112
51128612 0A825114 F5015211 150AF192 12861251 0A531451 F1015211 D108F196
D2511501 14511286 52110A53 F196F101 1501D108 D385D251 D1081751 01521101
0AF196F1 DA513312 08341351 523101D1 F196F101 5131110B 53D15131 311351D6
52310A53 F196F101 52D1140C 51D35212 0A533113 F1015231 150BF196 521252D1
521551D3 3101D108 96F10152 D1150BF1 1551D356 520B1151 F196F101 56D1150B
511551D3 97F10E11 91140AF1 51D354D3 F10EF116 F109F198 1451D896 F10CF193
989FFA9A 9F9F9FFC 0000949F
'Offset  1656
'PPC04 is compressed
801D0038
9F149B9F 12969F9F 9F9F12F2 F412949F 9D9F9F12 E3125471 9FF412F1 819AF597
12E15273 0412F1E3 F1959FF1 8398F105 E5125173 F1041251 07F1939F 85C195F1
51E51273 01D20112 F1939FF1 D2015101 C513F102 04CA7284 9A8395F1 055101F1
85C78112 F1998CCC 84055101 AB828FC7 F193F581 84053101 2AAD84C8 92F10581
053101F1 84C10AF1 0681AA2D 01F191F1 84020F31 822A81AB 050FF207 15832A83
F1078501 5206F191 D301D105 86178301 51115112 01820211 01D301D2 01F592F1
820A1152 12511451 11511286 F10B1251 5201F196 14530A11 12861251 F10A1551
5201F196 14530A11 D2861251 D1011551 F196F108 01115201 511708D1 51D285D3
08D10115 01F196F1 D1013152 51133408 123351DA F196F10A 0A315201 51133153
51D153D6 11315131 F196F10B 0A315201 51133153 521252D3 F10C14D1 5201F196
08D10131 D3511552 D1521252 96F10B15 0B5201F1 51155111 15D156D3 F196F10B
1551110E D156D351 96F10B15 16F10EF1 D354D351 F10A1491 F10CF198 D8511493
F109F196 989FFC9A 9F9F9FFA 0000009E
'Offset  2060
'PPC05 is compressed
801D0038
9F149B9F 12969F9F 9F9F12F2 F412949F 9D9F9F12 E3125471 9FF412F1 819AF597
12E15273 0412F1E3 F1959FF1 8398F105 E5125173 D2011251 939FF101 02D203F1
85C195F1 51E51273 9FF10412 3101F193 C513F105 04CA7284 9A8395F1 053101F1
85C78112 F1998CCC 84053101 AB828FC7 F193F581 84055101 2AAD84C8 92F10581
055101F1 84C10AF1 0681AA2D 01F191F1 84020F51 822A81AB D10DF207 8302D301
0115832A D301D185 F191F102 830B5206 51128617 02115111 92F10882 315201F5
1451820A 12861251 31513151 96F10B11 315201F1 1331530A 12861251 0A123351
01F196F1 530A3152 12511331 1551D286 F196F10A 0A315201 D3511334 1551D285
F196F10A 0A115201 51DA5117 08D10115 01F196F1 D1011152 51145308 51D153D6
02125111 96F108D1 115201F1 5308D101 52D35114 14D15212 F196F10C 01115201
155208D1 1252D351 0B15D152 01F196F1 51110B52 56D35115 F10B15D1 110EF196
D3511551 0B15D156 0EF196F1 D35116F1 1491D354 F198F10A 1493F10C F196D851
FC9AF109 9FFA989F 009E9F9F
'Offset  2460
'PPC06 is compressed
801D0038
9F9F9F9F 9F9F9F9F 9F9F9F9F 9F9F9F9F 9F9F9F9F 9F9F9F9F 9F9F9F9F 9F9F9F9F
929F9F9F 9F859582 93829C9F 9F84E2C4 9281959F C5E2C584 9F819485 F2C3829D
E2F286E2 819283C2 C2829C9F F1E281E1 F483E383 9F82C2E2 E1C1829C F8E2F582
E3F181E2 999F82C1 C1E1C181 E2F3E182 E2F184FB 959F81C2 C2829181 01FCE182
F184E1F5 9F81C1E1 E1C18296 F7FFC181 C1E184E1 81959F81 FFE181E2 E181E2F9
81C1E181 C281939F F2E2FEFF 9F81C1E1 E1F1C282 F902F7FF 9A84C1E1 FAE2C281
FB01FD01 C18AC2E3 01F7FFE2 82C3E2FE E2C68295 FB01F4FF 84C1E281 81C1829C
01F3FFE1 E2F3E1F6 81C1E181 C281939F F301F6E1 F602F401 82E1F3E1 959F81C2
E3C281C1 E2FF01F2 C283E1F1 86979F81 E1F4E4C4 C286E3F2 8C9A9F81 C685E2C3
0000009F
'Offset  2756
'PPC07 is compressed
801D0038
9F9F9F9F 9F9F9F9F 9F9F9F9F 9F9F9F9F 9F9F9F9F 9F9F9F9F 9C9F9F9F 9F9F9F81
01968299 929F9F9F 9F829683 9186969F 92859181 81940185 878F9D9F 9F829202
03858F9D 019A9F85 848F0192 9C9F8602 85C58703 959F8903 83059381 8FC2E4C2
939F0182 C1889183 C4E1F3E1 028CF1E1 E185949F E1C383F1 C2F4E1F1 E282F1E1
949F0386 C1F4E283 E1C1F8E3 0384E3F2 84949F81 E1F2FFE2 0285E2F4 E485939F
E5F501F1 0286E1F9 019C0191 F3E28791 F3E2F102 C1E1FBE1 019E0384 F9FFE187
830185C2 E187019C E1C4F7FF 019B0188 01F2E287 01F501F7 C1E1C2F6 01810185
E286039B E1F8FF01 9C0385C1 F2E28703 F101FEC1 0282C183 01910381 0291019A
01890181 81F482C1 0787F302 C40E919F 00990C88
'Offset  3036
'PPC08 is compressed
801D0038
9F81999F 979F0193 9F829D01 999F0191 9F829C01 019B9F01 029D839B 81029B9F
029B8499 979F8195 84988201 81940499 029E0198 93019283 93059785 94019782
84029A81 85910193 93028396 96019782 85029882 94018693 83930283 83970296
028D0396 92018691 92019383 94849902 87028E03 02958491 0294859A 018A028F
9C018194 8E039286 83928B02 06899D01 028F0289 8B018C9E 81018C02 91019E01
0188028E 0498038C 84038C95 8C018301 83029B02 85028691 F2E18102 9D01838F
E2838F02 E188E1F3 02810185 818F029D 84E2F5E2 0385E101 02950281 818F0295
F5E1F501 86E10181 93068103 81019402 FAE18D01 038901E2 02810181 E18C0894
E1F401F2 83E3C1F3 82028601 83059701 C1FD8603 028BE101 01910181 C1830299
F1FFE186 E282E182 839A0188 84C18201 F3C181C1 F381FBE1 0183C2E3 01910281
06940198 F701E182 F9E2F101 950383C4 95019301 E1018108 82F1C1F2 F202E4F2
910583C5 92019C02 E184C30B 01950D84 00000093
'Offset  3412
'PPC09 is compressed
801D0040
9F9F8498 9F869F9F 8A9E9F9F 949F9F9F 9A8F94E1 929F9F83 868F93E1 E1958594
E2F2989F 818F8FC2 81C1E192 919F8194 F58406F1 01E2878F 9F819283 820CF191
838FF501 82E282C2 0DF1919F F2E282C2 C38BF285 F282E382 F10EF19C C685C3E3
0BF284F2 09F19AF1 86C30653 F183F1C8 F199F10D 53035108 85035102 F10FF2CB
5108F198 51025204 C9048503 F198F10F 51045108 85025103 C3055104 F103530B
5108F197 510B5207 550D5104 F196F202 51075108 52065302 530C5404 F195F104
51075108 52025201 51085104 F105520D 5108F194 51025104 53025201 070F5103
F1520452 5108F193 01518403 05510357 05520F52 92F10151 028709F1 05510357
08520D54 0AF192F1 02570285 54018452 F108520D 850AF192 51025405 0C540185
93F10853 F38409F1 51025205 0C530185 95F10853 81F109F3 51F105F5 0FF20485
99F104F1 F2E181F8 F5E1F203 0E84F384 9FF491F1 8691E192 F481F3E4 E30282E1
9C9FF10C 0182C386 83C5E283 9C9FF605 95829281 81910181 8394C196 969F9FF3
9E9F9F81 00000000
End CSub
                                 